unit RSADemo2Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, stCustomProtoComp, stSecComp, StreamSec.DSI.ArithComp,
  ExtCtrls,
  stSHA1,
  stPkcs5;

type
  TfrmMain = class(TForm)
    btnCreateKey: TButton;
    memPrivKey: TMemo;
    RSAKey: TstRSAKey;
    Label1: TLabel;
    Label2: TLabel;
    memPublKey: TMemo;
    rgKeySize: TRadioGroup;
    btnSign: TButton;
    Label3: TLabel;
    btnVerify: TButton;
    memMsg: TMemo;
    Signature: TLabel;
    edtSign: TEdit;
    lblCreationTime: TLabel;
    lblSignStat: TLabel;
    btnEncrypt: TButton;
    btnDecrypt: TButton;
    edtPlainText: TEdit;
    edtCipherText: TEdit;
    edtDecrypted: TEdit;
    rgSignScheme: TRadioGroup;
    rgEncryptScheme: TRadioGroup;
    btnLoad: TButton;
    chbXMLFormat: TCheckBox;
    chbProvable: TCheckBox;
    chbNISTPrime: TCheckBox;
    procedure btnLoadClick(Sender: TObject);
    procedure memPrivKeyChange(Sender: TObject);
    procedure btnDecryptClick(Sender: TObject);
    procedure btnEncryptClick(Sender: TObject);
    procedure btnVerifyClick(Sender: TObject);
    procedure btnSignClick(Sender: TObject);
    procedure btnCreateKeyClick(Sender: TObject);
    procedure chbNISTPrimeClick(Sender: TObject);
  private
    fLoopCount: Integer;
  public
    procedure RSAKeyTerminate(Sender: TObject; var aTerminate: Boolean);
  end;

var
  frmMain: TfrmMain;

implementation

uses
  StreamSec.DSI.IFC, stSHA256, stAES, stDrbgAesCtr, StreamSec.DSI.CAPIFormat,
  StreamSec.DSI.NETFormat, StreamSec.DSI.PKTypes, stSecUtils;

{$R *.dfm}

procedure TfrmMain.btnCreateKeyClick(Sender: TObject);
var
  lTicks: Cardinal;
  lSS: TStringStream;
begin
  lTicks := GetTickCount;
  if chbProvable.Checked then
    RSAKey.KeyGenerationKind := RSAKey.KeyGenerationKind + [ifkgProvable]
  else
    RSAKey.KeyGenerationKind := RSAKey.KeyGenerationKind - [ifkgProvable];
  if chbNISTPrime.Checked then
    RSAKey.KeyGenerationKind := RSAKey.KeyGenerationKind + [ifkgNIST]
  else
    RSAKey.KeyGenerationKind := RSAKey.KeyGenerationKind - [ifkgNIST];

  fLoopCount := 0;
  RSAKey.OnTerminate := RSAKeyTerminate;
  case rgKeySize.ItemIndex of
    0: RSAKey.GenerateNewKeys(512,False);
    1: RSAKey.GenerateNewKeys(768,False);
    2: RSAKey.GenerateNewKeys(1024,False);
    3: RSAKey.GenerateNewKeys(2048,False);
    4: RSAKey.GenerateNewKeys(3072,False);
    5: RSAKey.GenerateNewKeys(4096,False);
    6: RSAKey.GenerateNewKeys(8192,False);
  end;
  lTicks := GetTickCount - lTicks;
  lblCreationTime.Caption := Format('Key pair created in %d ms, %d iterations',[lTicks,fLoopCount]);


  lSS := TStringStream.Create('');
  try
    if chbXMLFormat.Checked then begin
      // This will use the first selected format that implements the
      // iRSAXMLFormat interface
      RSAKey.SavePrivateKeyToStream(lSS,iRSAXMLFormat);
      memPrivKey.Text := StringReplace(lSS.DataString,'><','>'#13#10'<',[rfReplaceAll]);
      lSS.Size := 0;
      RSAKey.SavePublicKeyToStream(lSS,iRSAXMLFormat);
      memPublKey.Text := StringReplace(lSS.DataString,'><','>'#13#10'<',[rfReplaceAll]);
    end else begin
      // This will use the format that is first in the list of selected formats
      RSAKey.SavePrivateKeyToStream(lSS,iUnknown);
      memPrivKey.Text := lSS.DataString;
      lSS.Size := 0;
      RSAKey.SavePublicKeyToStream(lSS,iUnknown);
      memPublKey.Text := lSS.DataString;
    end;
  finally
    lSS.Free;
  end;
  btnSign.Enabled := True;
  btnEncrypt.Enabled := True;
end;

procedure TfrmMain.btnSignClick(Sender: TObject);
begin
  case rgSignScheme.ItemIndex of
    0: RSAKey.SignEncoding := seEMSA3;
    1: RSAKey.SignEncoding := seEMSA4;
  end;
  edtSign.Text := RSAKey.GenerateSignature(memMsg.Text,sfBase64);
  btnVerify.Enabled := True;
end;

procedure TfrmMain.btnVerifyClick(Sender: TObject);
begin                     
  case rgSignScheme.ItemIndex of
    0: RSAKey.SignEncoding := seEMSA3;
    1: RSAKey.SignEncoding := seEMSA4;
  end;
  if RSAKey.VerifySignature(memMsg.Text,edtSign.Text,sfBase64) then
    lblSignStat.Caption := 'OK'
  else
    lblSignStat.Caption := 'Failure';
end;

procedure TfrmMain.btnEncryptClick(Sender: TObject);
begin
  case rgEncryptScheme.ItemIndex of
    0: RSAKey.EncryptEncoding := eeEME_PKCS1_v1_5;
    1: RSAKey.EncryptEncoding := eeEME1;
  end;
  if Length(edtPlainText.Text) > RSAKey.EncodingRange then
    raise Exception.Create(Format('Plain text too large for key - %d (max %d)',[Length(edtPlainText.Text),RSAKey.EncodingRange]));
  edtCipherText.Text := RSAKey.Encrypt(edtPlainText.Text,'',sfBase64);
  btnDecrypt.Enabled := True;
end;

procedure TfrmMain.btnDecryptClick(Sender: TObject);
begin   
  case rgEncryptScheme.ItemIndex of
    0: RSAKey.EncryptEncoding := eeEME_PKCS1_v1_5;
    1: RSAKey.EncryptEncoding := eeEME1;
  end;
  edtDecrypted.Text := RSAKey.Decrypt(edtCipherText.Text,'',sfBase64);
end;

procedure TfrmMain.memPrivKeyChange(Sender: TObject);
begin
  btnLoad.Enabled := memPrivKey.Text <> ''; 
end;

procedure TfrmMain.RSAKeyTerminate(Sender: TObject; var aTerminate: Boolean);
begin
  Inc(fLoopCount);
end;

procedure TfrmMain.btnLoadClick(Sender: TObject);
var
  lSS: TStringStream;
  lPwd: iSecretKey;
  lPriv: iIFPrivateKey;
  lPubl: iIFPublicKey;
begin
  RSAKey.Enabled := False;
  lSS := TStringStream.Create(memPrivKey.Text);
  try
    lPwd := tSecretKey.CreateStr(PAnsiChar(AnsiString(RSAKey.PrivateKeyPassword)));
    RSAKey.SetPrivateKey(RSAKey.PrivateKeyFormat.LoadFromStream(lPwd,lSS,lPriv));
  finally
    lSS.Free;
  end;
  if memPublKey.Text <> '' then begin
    lSS := TStringStream.Create(memPublKey.Text);
    try
      RSAKey.SetPublicKey(RSAKey.PublicKeyFormat.LoadFromStream(lSS,lPubl));
    finally
      lSS.Free;
    end;
  end else begin
    lSS := TStringStream.Create(memPrivKey.Text);
    try
      RSAKey.SetPublicKey(RSAKey.PublicKeyFormat.LoadFromStream(lSS,lPubl));
    finally
      lSS.Free;
    end;
    lSS := TStringStream.Create(memPublKey.Text);
    try
      lSS.Size := 0;
      RSAKey.SavePublicKeyToStream(lSS,iRSAXmlFormat);
      memPublKey.Text := StringReplace(lSS.DataString,'><','>'#13#10'<',[rfReplaceAll]);
    finally
      lSS.Free;
    end;
  end;
  RSAKey.Enabled := True;
  btnSign.Enabled := True;
  btnEncrypt.Enabled := True;
end;

procedure TfrmMain.chbNISTPrimeClick(Sender: TObject);
begin
  if chbNISTPrime.Checked then begin
    chbProvable.Checked := True;
    chbProvable.Enabled := True;
  end else begin
    chbProvable.Checked := False;
    chbProvable.Enabled := False;
  end;
end;

end.
